{========================================================================}
{=                (c) 1995-02 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Anton Graff Str.31          = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
unit MMTools;

{$I COMPILER.INC}

{$DEFINE FULL_INSTALL}

{$IFDEF FULL_INSTALL}
       {$DEFINE _WAVE}
       {$DEFINE _VISUAL}
  {$IFDEF WIN32}
       {$DEFINE _DESIGN}
       {.$DEFINE _WMA}
       {$DEFINE _MPEG}
       {$DEFINE _CDROM}
       {$DEFINE _MIXER}
       {.$DEFINE _HDREC}
       {$DEFINE _FILTER}
       {$DEFINE _EFFECTS}
    {$IFNDEF CBUILDER}
       {$DEFINE _DSOUND}
       {$DEFINE _AVI}
    {$ENDIF}
       {.$DEFINE _DIRECTX}
       {.$DEFINE _PCX}
  {$ENDIF}
{$ENDIF}

{$IFDEF BUILD_ACTIVEX}
  {$UNDEF _DESIGN}
  {$UNDEF _MIXER}
  {$UNDEF _HDREC}
  {$UNDEF _AVI}
  {$UNDEF _DIRECTX}
{$ENDIF}

interface

procedure Register;

implementation

{$IFDEF WIN32}
   {$R MMTOOLS.D32}
{$ELSE}
   {$R MMTOOLS.D16}
{$ENDIF}

uses
    Controls,
    Classes,

    {$IFDEF DELPHI6}
    DesignIntf,
    DesignEditors,
    {$ELSE}
    DsgnIntf,
    {$ENDIF}

    {$IFNDEF DELPHI3}
    FiltEdit,
    {$ENDIF}

    SysUtils,
    MPlayer,
    MMAbout,
    MMObj,
    MMUtils,
    MMDesign,
    MMIde,
    MMPropEd,
    MMPanel,
    MMLabel,
    MMScroll,
    MMClrBtn,
    MMButton,
    MMLEDs,
    MMLEDLbl,
    MMSpin,
    MMSwitch,
    MMScrlr,
    MMCDInfo,
    MMHTimer,
    MMLTimer,
    MMSplit,
    MMWheel,
    MMEdit,
    MMSlider,
    MMGauge,
    MMEGauge,
    MMProgr

    {$IFDEF WIN32}
    ,MMProps,
    MMScrSv,
    MMMemMap,
    MMFFile,
    MMFFEdit,
    MMFFPrp,
    MMThread
    {$ENDIF}

    {$IFDEF _DESIGN}
    ,MMDesReg
    {$ENDIF}

    {$IFDEF _WAVE}
    ,MMWavReg
    {$ENDIF}

    {$IFDEF _VISUAL}
    ,MMVisReg
    {$ENDIF}

    {$IFDEF _WMA}
    ,MMWMAReg
    {$ENDIF}

    {$IFDEF _MPEG}
    ,MMMpReg
    {$ENDIF}

    {$IFDEF _CDROM}
    ,MMCDReg
    {$ENDIF}

    {$IFDEF _MIXER}
    ,MMMixReg
    {$ENDIF}

    {$IFDEF _HDREC}
    ,MMHdReg
    {$ENDIF}

    {$IFDEF _FILTER}
    ,MMFltReg
    {$ENDIF}

    {$IFDEF _EFFECTS}
    ,MMFXReg
    {$ENDIF}

    {$IFDEF _DSOUND}
    ,MMDsReg
    {$ENDIF}

    {$IFDEF _AVI}
    ,MMAVIReg
    {$ENDIF}

    {$IFDEF _DIRECTX}
    ,MMDXReg
    {$ENDIF}

    {$IFDEF _PCX}
    ,MMPCXReg
    {$ENDIF}
    ;

{=========================================================================}
procedure Register;
begin
     RegisterComponents('MMTools', [TMMDesigner,
                                  {$IFDEF WIN32}
                                    TMMProperties,
                                    TMMJoystickProperties,
                                    TMMThread,
                                    TMMMemMapFile,
                                    TMMFastFile,
                                    TMMFastFileDialog,
                                    TMMScreenSaver,
                                  {$ENDIF}
                                    TMMScroller,
                                    TMMHiTimer,
                                    TMMLongTimer,
                                    TMMCDInfo,
                                    TMMScrollPanel,
                                    TMMMarkerPanel,
                                    TMMLED,
                                    TMMLEDMode,
                                    TMMLEDDigit,
                                    TMMLEDPanel,
                                    TMMLEDLabel,
                                    TMMColorButton,
                                    TMMSpeedButton,
                                    TMMSpinButton,
                                    TMMLEDSpin,
                                    TMMSwitch,
                                    TMMWheel,
                                    TMMSlider,
                                    TMMGauge,
                                    TMMProgress,
                                    TMMLEDGauge,
                                    TMMNumberEdit,
                                    TMMFloatNumberEdit,
                                    TMMLabel,
                                    TMMSplitter,
                                    TMMBorder,
                                    TMMPanel]);

     {$IFDEF TRIAL}
     RegisterPropertyEditor(TypeInfo(TMMAboutBox),nil,'',TMMAboutBoxEditor);
     {$ENDIF}

     RegisterPropertyEditor(TypeInfo(TComponent),TMMLEDDigit,'Connect',TMMLEDDigitConnectEditor);

     {$IFDEF WIN32}
     RegisterPropertyEditor(TypeInfo(TFileName),TMMMemMapFile,'FileName',TMMMemMapFileNameProperty );
     RegisterPropertyEditor(TypeInfo(TFileName),TMMFastFile,'FileName',TMMFastFileNameProperty );
     {$ENDIF}

     RegisterPropertyEditor(TypeInfo(TWinControl),TMMSplitter,'SizeControl',TMMSplitterSizeControlEditor);

     RegisterComponentEditor(TMMDesigner, TMMDesignerEditor);

     {$IFDEF WIN32}
     RegisterComponentEditor(TMMFastFile, TMMFastFileEditor);
     RegisterComponentEditor(TMMPropertiesDialog, TMMPropertiesEditor);
     {$ENDIF}

     RegisterPropertyEditor(TypeInfo(TMMDeviceId),nil,'',TMMDeviceIdProperty);

     { register all additional packages }

     {$IFDEF _DESIGN}
     MMDesReg.Register;
     {$ENDIF}

     {$IFDEF _WAVE}
     MMWavReg.Register;
     {$ENDIF}

     {$IFDEF _VISUAL}
     MMVisReg.Register;
     {$ENDIF}

     {$IFDEF _WMA}
     MMWMAReg.Register;
     {$ENDIF}

     {$IFDEF _MPEG}
     MMMpReg.Register;
     {$ENDIF}

     {$IFDEF _CDROM}
     MMCDReg.Register;
     {$ENDIF}

     {$IFDEF _MIXER}
     MMMixReg.Register;
     {$ENDIF}

     {$IFDEF _HDREC}
     MMHdReg.Register;
     {$ENDIF}

     {$IFDEF _FILTER}
     MMFltReg.Register;
     {$ENDIF}

     {$IFDEF _EFFECTS}
     MMFXReg.Register;
     {$ENDIF}

     {$IFDEF _DSOUND}
     MMDsReg.Register;
     {$ENDIF}

     {$IFDEF _AVI}
     MMAVIReg.Register;
     {$ENDIF}

     {$IFDEF _DIRECTX}
     MMDXReg.Register;
     {$ENDIF}

     {$IFDEF _PCX}
     MMPCXReg.Register;
     {$ENDIF}

end;

initialization
     { Register the properties for TMMDesigner }
     RegisterProperty(ptOutput,'Misc',TMMCDInfo,'Player',TMediaPlayer,nil);
end.
